<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Dashboard de Usuarios</title>
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
</head>
<body>
  <h2>Lista de Usuarios</h2>
  <table id="tablaUsuarios" class="display" style="width:100%">
    <thead>
      <tr>
        <th>ID</th>
        <th>Nombre</th>
        <th>Apellido</th>
        <th>Correo</th>
        <th>Teléfono</th>
        <th>Calle</th>
        <th>Exterior</th>
        <th>Interior</th>
        <th>CP</th>
        <th>Colonia</th>
        <th>Creado</th>
        <th>Suscripción Activa</th>
        <th>Dispositivo</th>
      </tr>
    </thead>
    <tbody>
      <!-- Aquí se insertarán los datos dinámicamente -->
    </tbody>
  </table>

  <script>
    $(document).ready(function () {
      $('#tablaUsuarios').DataTable({
        ajax: {
          url: 'usuarios.php',
          dataSrc: ''
        },
        columns: [
          { data: 'id' },
          { data: 'nombre' },
          { data: 'apellido' },
          { data: 'correo' },
          { data: 'telefono' },
          { data: 'calle' },
          { data: 'exterior' },
          { data: 'interior' },
          { data: 'cp' },
          { data: 'colonia' },
          { data: 'creado_en' },
          {
            data: 'suscripcion_activa',
            render: function (data) {
              return data == 1 ? 'Sí' : 'No';
            }
          },
          { data: 'device' }
        ],
        order: [],
        language: {
          url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
        }
      });
    });
  </script>
</body>
</html>
